#include <iostream>
#include <vector>
#include <cmath>
using namespace std;

double max_distance = 0;

vector<int> x;
vector<int> y;
vector<int> stack;
vector<int> res;

void update_max_distance(double new_distance) {
    if (new_distance < max_distance) return;

    max_distance = new_distance;
    res = stack;
}


void backtrack(int cur_x, int cur_y, int i) {
    if (i==x.size()) {
        update_max_distance(hypot(cur_x, cur_y));
        return;
    }

    backtrack(cur_x, cur_y, i+1);

    stack.push_back(i);
    backtrack(cur_x + x[i], cur_y + y[i], i+1);
    stack.pop_back();
}

int main() {
    int n;
    cin>>n;

    x.resize(n);
    y.resize(n);


    for (int i = 0; i<n; i++) {
        cin>>x[i]>>y[i];
    }

    backtrack(0, 0, 0);

    cout<<res.size()<<"\n";

    for (int i = 0; i<res.size(); i++) {
        cout<<res[i] + 1<<" ";
    }
}